<?php
session_start();

// সাইট কনফিগারেশন
define('SITE_NAME', 'BD CLUB');
define('SITE_URL', 'http://localhost/bd-club/');
define('ADMIN_PATH', 'admin');

// ডাটাবেজ কনফিগারেশন
define('DB_HOST', 'localhost');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_NAME', 'bd_club');

// গেম সেটিংস
define('MIN_DEPOSIT', 100);
define('MIN_WITHDRAW', 500);
define('WELCOME_BONUS', 0);
define('REFERRAL_BONUS', 0);

// সিকিউরিটি
define('CSRF_TOKEN_NAME', 'csrf_token');

// টাইমজোন
date_default_timezone_set('Asia/Dhaka');

// ফাংশন: সাইট URL তৈরি
function site_url($path = '') {
    return SITE_URL . $path;
}

// ফাংশন: অ্যাডমিন URL তৈরি
function admin_url($path = '') {
    return SITE_URL . ADMIN_PATH . '/' . $path;
}

// ফাংশন: রিডাইরেক্ট
function redirect($url) {
    header("Location: " . $url);
    exit();
}

// ফাংশন: অ্যালার্ট মেসেজ
function set_message($type, $message) {
    $_SESSION['message'] = [
        'type' => $type,
        'text' => $message
    ];
}

function get_message() {
    if (isset($_SESSION['message'])) {
        $msg = $_SESSION['message'];
        unset($_SESSION['message']);
        return $msg;
    }
    return null;
}

// ফাংশন: ইউজার লগইন আছে কিনা চেক
function is_user_logged_in() {
    return isset($_SESSION['user_id']) && isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'user';
}

// ফাংশন: অ্যাডমিন লগইন আছে কিনা চেক
function is_admin_logged_in() {
    return isset($_SESSION['user_id']) && isset($_SESSION['user_role']) && $_SESSION['user_role'] == 'admin';
}

// CSRF টোকেন জেনারেট
function generate_csrf_token() {
    if (!isset($_SESSION[CSRF_TOKEN_NAME])) {
        $_SESSION[CSRF_TOKEN_NAME] = bin2hex(random_bytes(32));
    }
    return $_SESSION[CSRF_TOKEN_NAME];
}

// CSRF টোকেন ভেরিফাই
function verify_csrf_token($token) {
    return isset($_SESSION[CSRF_TOKEN_NAME]) && hash_equals($_SESSION[CSRF_TOKEN_NAME], $token);
}
?>