<?php
require_once 'includes/config.php';
require_once 'includes/db.php';
require_once 'includes/auth.php';

// লগইন চেক
if (!is_user_logged_in()) {
    redirect('index.php');
}

$user_id = $_SESSION['user_id'];
$user = db_fetch("SELECT * FROM users WHERE id = ?", [$user_id]);

// ব্যালেন্স আপডেট
$total_balance = $user['deposit_balance'] + $user['winning_balance'];

// গেম হিস্ট্রি
$game_history = db_fetch_all("SELECT * FROM game_results ORDER BY id DESC LIMIT 10");

// ইউজারের বেটিং হিস্ট্রি
$my_bets = db_fetch_all("SELECT * FROM bets WHERE user_id = ? ORDER BY id DESC LIMIT 20", [$user_id]);
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BD CLUB - ড্যাশবোর্ড</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        /* আপনার পুরো CSS এখানে */
        /* আমি শুধু কাঠামো দেখাচ্ছি */
    </style>
</head>
<body>
    <!-- হেডার -->
    <header class="header">
        <h1>BD CLUB</h1>
        <div class="balance">
            ব্যালেন্স: ৳<?php echo number_format($total_balance, 2); ?>
        </div>
    </header>
    
    <!-- নেভিগেশন -->
    <nav class="nav">
        <a href="dashboard.php" class="active">হোম</a>
        <a href="wallet.php">ওয়ালেট</a>
        <a href="game.php">গেম</a>
        <a href="profile.php">প্রোফাইল</a>
    </nav>
    
    <!-- কন্টেন্ট -->
    <div class="container">
        <!-- নোটিশ -->
        <div class="notice">
            <?php
            $notice = db_fetch("SELECT setting_value FROM settings WHERE setting_key = 'notice'");
            echo $notice['setting_value'] ?? 'স্বাগতম BD CLUB এ!';
            ?>
        </div>
        
        <!-- গেম সেকশন -->
        <div class="game-section">
            <h2>WinGo 1 Min</h2>
            <div class="timer">
                <div id="countdown">60s</div>
                <div>পরবর্তী রাউন্ড</div>
            </div>
            
            <!-- বেটিং অপশন -->
            <div class="betting-options">
                <button class="bet-btn green" data-bet="green">Green</button>
                <button class="bet-btn red" data-bet="red">Red</button>
                <button class="bet-btn violet" data-bet="violet">Violet</button>
                
                <div class="number-grid">
                    <?php for($i=0; $i<=9; $i++): ?>
                        <button class="number-btn" data-bet="<?php echo $i; ?>"><?php echo $i; ?></button>
                    <?php endfor; ?>
                </div>
                
                <button class="bet-btn big" data-bet="big">Big</button>
                <button class="bet-btn small" data-bet="small">Small</button>
            </div>
        </div>
        
        <!-- হিস্ট্রি -->
        <div class="history-section">
            <div class="tabs">
                <button class="tab-btn active" onclick="showTab('game-history')">গেম হিস্ট্রি</button>
                <button class="tab-btn" onclick="showTab('my-history')">আমার হিস্ট্রি</button>
            </div>
            
            <div class="tab-content active" id="game-history">
                <table>
                    <tr>
                        <th>পিরিয়ড</th>
                        <th>নম্বর</th>
                        <th>রং</th>
                        <th>সাইজ</th>
                    </tr>
                    <?php foreach($game_history as $history): ?>
                    <tr>
                        <td><?php echo $history['period']; ?></td>
                        <td><?php echo $history['number']; ?></td>
                        <td><?php echo $history['color']; ?></td>
                        <td><?php echo $history['size']; ?></td>
                    </tr>
                    <?php endforeach; ?>
                </table>
            </div>
            
            <div class="tab-content" id="my-history">
                <table>
                    <tr>
                        <th>সময়</th>
                        <th>বেট</th>
                        <th>পরিমাণ</th>
                        <th>রেজাল্ট</th>
                    </tr>
                    <?php foreach($my_bets as $bet): ?>
                    <tr>
                        <td><?php echo date('H:i', strtotime($bet['created_at'])); ?></td>
                        <td><?php echo $bet['bet_type']; ?></td>
                        <td>৳<?php echo number_format($bet['amount'], 2); ?></td>
                        <td class="<?php echo $bet['result'] == 'win' ? 'win' : 'loss'; ?>">
                            <?php 
                            if($bet['result'] == 'win') {
                                echo '+৳' . number_format($bet['win_amount'], 2);
                            } elseif($bet['result'] == 'loss') {
                                echo '-৳' . number_format($bet['amount'], 2);
                            } else {
                                echo 'Pending';
                            }
                            ?>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </table>
            </div>
        </div>
    </div>
    
    <!-- ফুটার -->
    <footer>
        <p>© 2024 BD CLUB. All rights reserved.</p>
    </footer>
    
    <!-- জাভাস্ক্রিপ্ট -->
    <script src="assets/js/main.js"></script>
    <script>
        // টাইমার
        let timeLeft = 60;
        const timerElement = document.getElementById('countdown');
        
        function updateTimer() {
            timeLeft--;
            if(timeLeft < 0) {
                timeLeft = 60;
                // রিফ্রেশ গেম
                location.reload();
            }
            timerElement.textContent = timeLeft + 's';
        }
        
        setInterval(updateTimer, 1000);
        
        // ট্যাব সুইচ
        function showTab(tabId) {
            // সব ট্যাব হাইড
            document.querySelectorAll('.tab-content').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // সব বাটন ইনএক্টিভ
            document.querySelectorAll('.tab-btn').forEach(btn => {
                btn.classList.remove('active');
            });
            
            // সিলেক্টেড ট্যাব শো
            document.getElementById(tabId).classList.add('active');
            event.target.classList.add('active');
        }
        
        // বেটিং সিস্টেম
        document.querySelectorAll('.bet-btn, .number-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const betType = this.dataset.bet;
                const amount = prompt('বেটের পরিমাণ লিখুন:', '10');
                
                if(amount && !isNaN(amount) && amount > 0) {
                    // AJAX রিকুয়েস্ট বেট প্লেস করার জন্য
                    fetch('place_bet.php', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                        },
                        body: JSON.stringify({
                            bet_type: betType,
                            amount: amount
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if(data.success) {
                            alert('বেট সফলভাবে প্লেস হয়েছে!');
                            location.reload();
                        } else {
                            alert('বেট ব্যর্থ: ' + data.message);
                        }
                    });
                }
            });
        });
    </script>
</body>
</html>