<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

// যদি ইতিমধ্যে অ্যাডমিন লগইন করা থাকে
if (is_admin_logged_in()) {
    redirect('dashboard.php');
}

$error = '';

// অ্যাডমিন লগইন প্রসেস
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    
    // প্রথমে চেক করুন অ্যাডমিন টেবিলে আছে কিনা
    $admin = db_fetch("SELECT * FROM admins WHERE username = ?", [$username]);
    
    if ($admin && password_verify($password, $admin['password'])) {
        $_SESSION['user_id'] = $admin['id'];
        $_SESSION['user_role'] = 'admin';
        $_SESSION['admin_username'] = $admin['username'];
        
        redirect('dashboard.php');
    } else {
        // ব্যাকআপ: যদি এডমিন টেবিল না থাকে, হার্ডকোডেড ক্রিডেনশিয়াল
        $hardcoded_username = 'admin';
        $hardcoded_password = 'admin123'; // প্রথমে এই পাসওয়ার্ড ব্যবহার করুন
        
        if ($username === $hardcoded_username && $password === $hardcoded_password) {
            // সেশন সেট করুন
            $_SESSION['user_id'] = 1;
            $_SESSION['user_role'] = 'admin';
            $_SESSION['admin_username'] = 'admin';
            
            // অ্যাডমিন টেবিলে সেভ করুন (যদি না থাকে)
            $existing_admin = db_fetch("SELECT id FROM admins WHERE username = 'admin'");
            if (!$existing_admin) {
                $admin_data = [
                    'username' => 'admin',
                    'password' => password_hash('admin123', PASSWORD_DEFAULT),
                    'email' => 'admin@bdclub.com',
                    'created_at' => date('Y-m-d H:i:s')
                ];
                db_insert('admins', $admin_data);
            }
            
            redirect('dashboard.php');
        } else {
            $error = "ভুল ইউজারনেম বা পাসওয়ার্ড";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>BD CLUB - অ্যাডমিন লগইন</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            width: 100%;
            max-width: 400px;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 30px;
        }
        
        .login-header h2 {
            color: #333;
            margin-bottom: 10px;
        }
        
        .login-header p {
            color: #666;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #555;
            font-weight: bold;
        }
        
        .form-group input {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        
        .btn-login {
            width: 100%;
            padding: 12px;
            background: #4CAF50;
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            cursor: pointer;
            transition: background 0.3s;
        }
        
        .btn-login:hover {
            background: #45a049;
        }
        
        .alert {
            padding: 10px;
            margin-bottom: 20px;
            border-radius: 5px;
        }
        
        .alert-error {
            background: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        
        .note {
            margin-top: 20px;
            padding: 10px;
            background: #e7f3ff;
            border-radius: 5px;
            font-size: 14px;
            color: #31708f;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h2>BD CLUB অ্যাডমিন প্যানেল</h2>
            <p>অ্যাডমিন অ্যাক্সেসের জন্য লগইন করুন</p>
        </div>
        
        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="username">ইউজারনেম</label>
                <input type="text" id="username" name="username" required autofocus>
            </div>
            
            <div class="form-group">
                <label for="password">পাসওয়ার্ড</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <button type="submit" class="btn-login">লগইন</button>
        </form>
        
        <div class="note">
            <strong>ডিফল্ট ক্রিডেনশিয়াল:</strong><br>
            ইউজারনেম: admin<br>
            পাসওয়ার্ড: admin123<br>
            প্রথম লগইনের পর পাসওয়ার্ড পরিবর্তন করুন।
        </div>
    </div>
</body>
</html>