<?php
require_once '../includes/config.php';
require_once '../includes/db.php';

// অ্যাডমিন চেক
if (!is_admin_logged_in()) {
    redirect('index.php');
}

// স্ট্যাটিস্টিক্স
$total_users = db_fetch("SELECT COUNT(*) as total FROM users")['total'];
$total_deposits = db_fetch("SELECT SUM(amount) as total FROM deposits WHERE status = 'approved'")['total'] ?? 0;
$total_withdrawals = db_fetch("SELECT SUM(amount) as total FROM withdrawals WHERE status = 'approved'")['total'] ?? 0;
$pending_deposits = db_fetch("SELECT COUNT(*) as total FROM deposits WHERE status = 'pending'")['total'];
$pending_withdrawals = db_fetch("SELECT COUNT(*) as total FROM withdrawals WHERE status = 'pending'")['total'];

// রিসেন্ট এক্টিভিটি
$recent_users = db_fetch_all("SELECT * FROM users ORDER BY id DESC LIMIT 5");
$recent_deposits = db_fetch_all("SELECT d.*, u.uiid, u.name FROM deposits d JOIN users u ON d.user_id = u.id ORDER BY d.id DESC LIMIT 5");
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>অ্যাডমিন ড্যাশবোর্ড - BD CLUB</title>
    <link rel="stylesheet" href="../assets/css/admin.css">
    <style>
        .dashboard-stats {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .stat-card h3 {
            color: #666;
            margin-bottom: 10px;
            font-size: 14px;
        }
        
        .stat-card .number {
            font-size: 32px;
            font-weight: bold;
            color: #333;
        }
        
        .stat-card.users { border-top: 4px solid #4CAF50; }
        .stat-card.deposits { border-top: 4px solid #2196F3; }
        .stat-card.withdrawals { border-top: 4px solid #FF9800; }
        .stat-card.pending { border-top: 4px solid #F44336; }
        
        .recent-activity {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }
        
        .activity-card {
            background: white;
            padding: 20px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        
        .activity-card h3 {
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
        }
        
        th {
            background: #f5f5f5;
            padding: 10px;
            text-align: left;
            font-weight: bold;
        }
        
        td {
            padding: 10px;
            border-bottom: 1px solid #eee;
        }
        
        .status {
            padding: 3px 8px;
            border-radius: 3px;
            font-size: 12px;
        }
        
        .status-pending { background: #FFF3CD; color: #856404; }
        .status-approved { background: #D4EDDA; color: #155724; }
        .status-rejected { background: #F8D7DA; color: #721C24; }
    </style>
</head>
<body>
    <!-- অ্যাডমিন হেডার -->
    <div class="admin-header">
        <div class="logo">
            <h2>BD CLUB অ্যাডমিন প্যানেল</h2>
        </div>
        <div class="admin-info">
            স্বাগতম, <?php echo $_SESSION['admin_username']; ?>!
            <a href="logout.php" class="logout-btn">লগআউট</a>
        </div>
    </div>
    
    <!-- অ্যাডমিন সাইডবার -->
    <div class="admin-container">
        <div class="admin-sidebar">
            <ul>
                <li><a href="dashboard.php" class="active">ড্যাশবোর্ড</a></li>
                <li><a href="users.php">ইউজার ম্যানেজমেন্ট</a></li>
                <li><a href="deposits.php">ডিপোজিট রিকুয়েস্ট</a></li>
                <li><a href="withdrawals.php">উইথড্র রিকুয়েস্ট</a></li>
                <li><a href="giftcodes.php">গিফট কোড</a></li>
                <li><a href="settings.php">সেটিংস</a></li>
            </ul>
        </div>
        
        <!-- মেইন কন্টেন্ট -->
        <div class="admin-content">
            <h1>অ্যাডমিন ড্যাশবোর্ড</h1>
            
            <!-- স্ট্যাটস -->
            <div class="dashboard-stats">
                <div class="stat-card users">
                    <h3>মোট ইউজার</h3>
                    <div class="number"><?php echo $total_users; ?></div>
                </div>
                
                <div class="stat-card deposits">
                    <h3>মোট ডিপোজিট</h3>
                    <div class="number">৳<?php echo number_format($total_deposits, 2); ?></div>
                </div>
                
                <div class="stat-card withdrawals">
                    <h3>মোট উইথড্র</h3>
                    <div class="number">৳<?php echo number_format($total_withdrawals, 2); ?></div>
                </div>
                
                <div class="stat-card pending">
                    <h3>পেন্ডিং রিকুয়েস্ট</h3>
                    <div class="number"><?php echo $pending_deposits + $pending_withdrawals; ?></div>
                </div>
            </div>
            
            <!-- রিসেন্ট এক্টিভিটি -->
            <div class="recent-activity">
                <div class="activity-card">
                    <h3>নতুন ইউজার</h3>
                    <table>
                        <tr>
                            <th>ইউজার আইডি</th>
                            <th>নাম</th>
                            <th>ফোন</th>
                            <th>তারিখ</th>
                        </tr>
                        <?php foreach($recent_users as $user): ?>
                        <tr>
                            <td><?php echo $user['uiid']; ?></td>
                            <td><?php echo $user['name']; ?></td>
                            <td><?php echo $user['phone']; ?></td>
                            <td><?php echo date('d/m/Y', strtotime($user['created_at'])); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                
                <div class="activity-card">
                    <h3>রিসেন্ট ডিপোজিট</h3>
                    <table>
                        <tr>
                            <th>ইউজার</th>
                            <th>পরিমাণ</th>
                            <th>মেথড</th>
                            <th>স্ট্যাটাস</th>
                        </tr>
                        <?php foreach($recent_deposits as $deposit): ?>
                        <tr>
                            <td><?php echo $deposit['name']; ?></td>
                            <td>৳<?php echo number_format($deposit['amount'], 2); ?></td>
                            <td><?php echo $deposit['method']; ?></td>
                            <td>
                                <span class="status status-<?php echo $deposit['status']; ?>">
                                    <?php echo $deposit['status']; ?>
                                </span>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
            </div>
            
            <!-- কোয়িক অ্যাকশন -->
            <div class="quick-actions" style="margin-top: 30px;">
                <h3>কোয়িক অ্যাকশন</h3>
                <div style="display: flex; gap: 10px; margin-top: 15px;">
                    <a href="users.php?action=add" class="btn">নতুন ইউজার যোগ</a>
                    <a href="giftcodes.php?action=generate" class="btn">গিফট কোড জেনারেট</a>
                    <a href="settings.php" class="btn">সেটিংস আপডেট</a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>